/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.content.blocks.kinetics.furnace_engine;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.flywheel.FlywheelBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.placement.IPlacementHelper;
import com.simibubi.create.foundation.placement.PlacementHelpers;
import com.simibubi.create.foundation.placement.PlacementOffset;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.util.entry.BlockEntry;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;
import uwu.lopyluna.create_dd.content.blocks.kinetics.furnace_engine.FurnaceEngineBlockEntity;
import uwu.lopyluna.create_dd.content.blocks.kinetics.furnace_engine.PoweredFlywheelBlock;
import uwu.lopyluna.create_dd.registry.DesiresBlockEntityTypes;
import uwu.lopyluna.create_dd.registry.DesiresBlocks;

@ParametersAreNonnullByDefault
@Mod.EventBusSubscriber
public class FurnaceEngineBlock
extends FaceAttachedHorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWrenchable,
IBE<FurnaceEngineBlockEntity> {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public FurnaceEngineBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR)).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return FurnaceEngineBlock.m_53196_(pLevel, pPos, FurnaceEngineBlock.m_53200_((BlockState)pState).m_122424_()) && FurnaceEngineBlock.isValidPosition(pLevel, pPos.m_121945_(FurnaceEngineBlock.m_53200_((BlockState)pState).m_122424_()), FurnaceEngineBlock.m_53200_((BlockState)pState));
    }

    public static boolean m_53196_(LevelReader pReader, BlockPos pPos, Direction pDirection) {
        BlockPos blockpos = pPos.m_121945_(pDirection);
        return pReader.m_8055_(blockpos).m_60734_() instanceof AbstractFurnaceBlock;
    }

    public static boolean isValidPosition(LevelReader world, BlockPos pos, Direction facing) {
        for (Direction otherFacing : Iterate.directions) {
            BlockPos otherPos;
            BlockState otherState;
            if (otherFacing == facing || !((otherState = world.m_8055_(otherPos = pos.m_121945_(otherFacing))).m_60734_() instanceof FurnaceEngineBlock)) continue;
            return false;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder.m_61104_(new Property[]{f_53179_, f_54117_, BlockStateProperties.f_61362_}));
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(heldItem)) {
            return placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState ifluidstate = level.m_6425_(pos);
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
    }

    @SubscribeEvent
    public static void usingFurnaceEngineOnFurnacePreventsGUI(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (blockItem.m_40614_() != DesiresBlocks.FURNACE_ENGINE.get()) {
            return;
        }
        BlockState state = event.getLevel().m_8055_(event.getPos());
        if (state.m_60734_() instanceof AbstractFurnaceBlock) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public static Direction getFacing(BlockState sideState) {
        return FurnaceEngineBlock.m_53200_((BlockState)sideState);
    }

    public static BlockPos getFlywheelPos(BlockState sideState, BlockPos pos) {
        return pos.m_5484_(FurnaceEngineBlock.m_53200_((BlockState)sideState), 2);
    }

    public static boolean isFlywheelValid(BlockState state, BlockState shaft) {
        return (AllBlocks.FLYWHEEL.has(shaft) || DesiresBlocks.POWERED_FLYWHEEL.has(shaft)) && shaft.m_61143_((Property)RotatedPillarKineticBlock.AXIS) != FurnaceEngineBlock.getFacing(state).m_122434_();
    }

    public Class<FurnaceEngineBlockEntity> getBlockEntityClass() {
        return FurnaceEngineBlockEntity.class;
    }

    public BlockEntityType<? extends FurnaceEngineBlockEntity> getBlockEntityType() {
        return (BlockEntityType)DesiresBlockEntityTypes.FURNACE_ENGINE.get();
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        VoxelShape up_z = Stream.of(Block.m_49796_((double)1.5, (double)4.0, (double)2.0, (double)14.5, (double)14.0, (double)14.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.5, (double)1.5, (double)13.0, (double)12.5), Block.m_49796_((double)-1.0, (double)-3.0, (double)-1.0, (double)17.0, (double)4.0, (double)17.0), Block.m_49796_((double)14.5, (double)3.0, (double)3.5, (double)16.0, (double)13.0, (double)12.5), Block.m_49796_((double)3.5, (double)4.0, (double)0.0, (double)12.5, (double)11.0, (double)2.0), Block.m_49796_((double)3.5, (double)4.0, (double)14.0, (double)12.5, (double)11.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape up_x = Stream.of(Block.m_49796_((double)2.0, (double)4.0, (double)1.5, (double)14.0, (double)14.0, (double)14.5), Block.m_49796_((double)3.5, (double)3.0, (double)14.5, (double)12.5, (double)13.0, (double)16.0), Block.m_49796_((double)-1.0, (double)-3.0, (double)-1.0, (double)17.0, (double)4.0, (double)17.0), Block.m_49796_((double)3.5, (double)3.0, (double)0.0, (double)12.5, (double)13.0, (double)1.5), Block.m_49796_((double)0.0, (double)4.0, (double)3.5, (double)2.0, (double)11.0, (double)12.5), Block.m_49796_((double)14.0, (double)4.0, (double)3.5, (double)16.0, (double)11.0, (double)12.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape down_z = Stream.of(Block.m_49796_((double)1.5, (double)2.0, (double)2.0, (double)14.5, (double)12.0, (double)14.0), Block.m_49796_((double)14.5, (double)3.0, (double)3.5, (double)16.0, (double)13.0, (double)12.5), Block.m_49796_((double)-1.0, (double)12.0, (double)-1.0, (double)17.0, (double)19.0, (double)17.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.5, (double)1.5, (double)13.0, (double)12.5), Block.m_49796_((double)3.5, (double)5.0, (double)0.0, (double)12.5, (double)12.0, (double)2.0), Block.m_49796_((double)3.5, (double)5.0, (double)14.0, (double)12.5, (double)12.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape down_x = Stream.of(Block.m_49796_((double)2.0, (double)2.0, (double)1.5, (double)14.0, (double)12.0, (double)14.5), Block.m_49796_((double)3.5, (double)3.0, (double)0.0, (double)12.5, (double)13.0, (double)1.5), Block.m_49796_((double)-1.0, (double)12.0, (double)-1.0, (double)17.0, (double)19.0, (double)17.0), Block.m_49796_((double)3.5, (double)3.0, (double)14.5, (double)12.5, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)5.0, (double)3.5, (double)2.0, (double)12.0, (double)12.5), Block.m_49796_((double)14.0, (double)5.0, (double)3.5, (double)16.0, (double)12.0, (double)12.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape wall_north = Stream.of(Block.m_49796_((double)1.5, (double)2.0, (double)2.0, (double)14.5, (double)14.0, (double)12.0), Block.m_49796_((double)0.0, (double)3.5, (double)3.0, (double)1.5, (double)12.5, (double)13.0), Block.m_49796_((double)-1.0, (double)-1.0, (double)12.0, (double)17.0, (double)17.0, (double)19.0), Block.m_49796_((double)14.5, (double)3.5, (double)3.0, (double)16.0, (double)12.5, (double)13.0), Block.m_49796_((double)3.5, (double)0.0, (double)5.0, (double)12.5, (double)2.0, (double)12.0), Block.m_49796_((double)3.5, (double)14.0, (double)5.0, (double)12.5, (double)16.0, (double)12.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape wall_south = Stream.of(Block.m_49796_((double)1.5, (double)2.0, (double)4.0, (double)14.5, (double)14.0, (double)14.0), Block.m_49796_((double)14.5, (double)3.5, (double)3.0, (double)16.0, (double)12.5, (double)13.0), Block.m_49796_((double)-1.0, (double)-1.0, (double)-3.0, (double)17.0, (double)17.0, (double)4.0), Block.m_49796_((double)0.0, (double)3.5, (double)3.0, (double)1.5, (double)12.5, (double)13.0), Block.m_49796_((double)3.5, (double)0.0, (double)4.0, (double)12.5, (double)2.0, (double)11.0), Block.m_49796_((double)3.5, (double)14.0, (double)4.0, (double)12.5, (double)16.0, (double)11.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape wall_east = Stream.of(Block.m_49796_((double)4.0, (double)2.0, (double)1.5, (double)14.0, (double)14.0, (double)14.5), Block.m_49796_((double)3.0, (double)3.5, (double)0.0, (double)13.0, (double)12.5, (double)1.5), Block.m_49796_((double)-3.0, (double)-1.0, (double)-1.0, (double)4.0, (double)17.0, (double)17.0), Block.m_49796_((double)3.0, (double)3.5, (double)14.5, (double)13.0, (double)12.5, (double)16.0), Block.m_49796_((double)4.0, (double)0.0, (double)3.5, (double)11.0, (double)2.0, (double)12.5), Block.m_49796_((double)4.0, (double)14.0, (double)3.5, (double)11.0, (double)16.0, (double)12.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        VoxelShape wall_west = Stream.of(Block.m_49796_((double)2.0, (double)2.0, (double)1.5, (double)12.0, (double)14.0, (double)14.5), Block.m_49796_((double)3.0, (double)3.5, (double)14.5, (double)13.0, (double)12.5, (double)16.0), Block.m_49796_((double)12.0, (double)-1.0, (double)-1.0, (double)19.0, (double)17.0, (double)17.0), Block.m_49796_((double)3.0, (double)3.5, (double)0.0, (double)13.0, (double)12.5, (double)1.5), Block.m_49796_((double)5.0, (double)0.0, (double)3.5, (double)12.0, (double)2.0, (double)12.5), Block.m_49796_((double)5.0, (double)14.0, (double)3.5, (double)12.0, (double)16.0, (double)12.5)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
        AttachFace face = (AttachFace)pState.m_61143_((Property)f_53179_);
        Direction direction = (Direction)pState.m_61143_((Property)f_54117_);
        return face == AttachFace.CEILING ? (direction.m_122434_() == Direction.Axis.X ? down_x : down_z) : (face == AttachFace.FLOOR ? (direction.m_122434_() == Direction.Axis.X ? up_x : up_z) : (direction == Direction.NORTH ? wall_north : (direction == Direction.SOUTH ? wall_south : (direction == Direction.EAST ? wall_east : wall_west))));
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        BlockPos shaftPos = FurnaceEngineBlock.getFlywheelPos(pState, pPos);
        BlockState shaftState = pLevel.m_8055_(shaftPos);
        if (FurnaceEngineBlock.isFlywheelValid(pState, shaftState)) {
            pLevel.m_7731_(shaftPos, PoweredFlywheelBlock.getEquivalent(shaftState, (Direction.Axis)shaftState.m_61143_((Property)RotatedPillarKineticBlock.AXIS)), 3);
        }
    }

    public static Couple<Integer> getSpeedRange() {
        return Couple.create((Object)0, (Object)32);
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> ((BlockEntry)AllBlocks.FLYWHEEL).isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return s -> s.m_60734_() instanceof FurnaceEngineBlock;
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction direction;
            BlockPos shaftPos = FurnaceEngineBlock.getFlywheelPos(state, pos);
            BlockState shaft = AllBlocks.FLYWHEEL.getDefaultState();
            Direction[] directionArray = Direction.m_122382_((Entity)player);
            int n = directionArray.length;
            for (int i = 0; i < n && !FurnaceEngineBlock.isFlywheelValid(state, shaft = (BlockState)shaft.m_61124_((Property)FlywheelBlock.AXIS, (Comparable)(direction = directionArray[i]).m_122434_())); ++i) {
            }
            BlockState newState = world.m_8055_(shaftPos);
            if (!newState.m_247087_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = (Direction.Axis)shaft.m_61143_((Property)FlywheelBlock.AXIS);
            return PlacementOffset.success((Vec3i)shaftPos, s -> (BlockState)BlockHelper.copyProperties((BlockState)s, (BlockState)DesiresBlocks.POWERED_FLYWHEEL.getDefaultState()).m_61124_((Property)PoweredFlywheelBlock.AXIS, (Comparable)axis));
        }
    }
}

